/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.entity.bat.ex;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.explosive.IExplosiveHolder;
import com.builtbroken.mc.core.content.entity.bat.EntityCreatureBat;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.imp.transform.vector.Location;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityExBat
extends EntityCreatureBat
implements IExplosiveHolder,
IEntityAdditionalSpawnData {
    public static int DATA_FUSE_TIMER = 17;
    public static int TYPE_NORMAL = 0;
    public static int TYPE_HOSTILE = 1;
    public static int TYPE_BOMB = 2;
    protected int fuseTicks = 10;
    protected boolean enableFuse = false;
    public int explosiveTimer = -1;
    public int ai_type = 0;
    private boolean isAISetup = false;
    protected double ex_size = 3.0;
    protected IExplosiveHandler ex;
    protected NBTTagCompound ex_data;
    public IPos3D target;

    public EntityExBat(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    protected void setupAI() {
        if (this.ai_type == TYPE_NORMAL || this.ai_type == TYPE_HOSTILE) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
            if (this.ai_type == TYPE_HOSTILE) {
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 0, true));
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(DATA_FUSE_TIMER, (Object)-1);
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 1.0;
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    @Override
    public void func_70071_h_() {
        if (!this.isAISetup) {
            this.isAISetup = true;
            this.setupAI();
        }
        if (this.func_70089_S()) {
            if (this.explosiveTimer > 0) {
                --this.explosiveTimer;
            }
            this.enableFuse = this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 9.0;
            int fuse = this.getFuse();
            if (fuse > 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            if (this.isFuseActive()) {
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                }
                this.setFuse(fuse + 1);
            } else if (fuse > 1) {
                this.setFuse(fuse - 1);
            }
            if (fuse >= this.fuseTicks) {
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void doBatLogic() {
        if (this.isBatHanging()) {
            this.setIsBatHanging(false);
            this.field_70170_p.func_72889_a(null, 1015, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        }
    }

    protected boolean isFuseActive() {
        return this.enableFuse || this.explosiveTimer == 0;
    }

    public boolean func_70652_k(Entity entity) {
        return true;
    }

    @Override
    public IExplosiveHandler getExplosive() {
        return this.ex;
    }

    @Override
    public boolean setExplosive(IExplosiveHandler ex, double size, NBTTagCompound nbt) {
        this.ex_size = size;
        this.ex = ex;
        this.ex_data = nbt;
        return true;
    }

    @Override
    public NBTTagCompound getAdditionalExplosiveData() {
        return this.ex_data;
    }

    @Override
    public double getExplosiveSize() {
        return this.ex_size;
    }

    protected void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean allow_mob_damage = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (this.ex == null) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.ex_size, allow_mob_damage);
            } else {
                ExplosiveRegistry.triggerExplosive(new Location((Entity)this), this.ex, new TriggerCause.TriggerCauseEntity((Entity)this), this.ex_size, this.ex_data);
            }
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("explosiveTimer", this.explosiveTimer);
        nbt.func_74777_a("fuse", (short)this.fuseTicks);
        nbt.func_74768_a("ai_type", this.ai_type);
        if (this.ex != null) {
            nbt.func_74778_a("ex", this.ex.getID());
            nbt.func_74780_a("size", this.ex_size);
            if (this.ex_data != null) {
                nbt.func_74782_a("ex_data", (NBTBase)this.ex_data);
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("explosiveTimer")) {
            this.explosiveTimer = nbt.func_74762_e("explosiveTimer");
        }
        this.fuseTicks = nbt.func_74765_d("fuse");
        this.ai_type = nbt.func_74762_e("ai_type");
        if (nbt.func_74764_b("ex")) {
            this.ex = ExplosiveRegistry.get(nbt.func_74779_i("ex"));
            this.ex_size = Math.max(nbt.func_74769_h("size"), 1.0);
            if (nbt.func_74764_b("ex_data")) {
                this.ex_data = nbt.func_74775_l("ex_data");
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.ex != null);
        if (this.ex != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ex.getID());
            if (this.ex_data != null) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.ex_data);
            } else {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)new NBTTagCompound());
            }
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        boolean ex_exists = buffer.readBoolean();
        if (ex_exists) {
            this.ex = ExplosiveRegistry.get(ByteBufUtils.readUTF8String((ByteBuf)buffer));
            this.ex_data = ByteBufUtils.readTag((ByteBuf)buffer);
        } else {
            this.ex = null;
            this.ex_data = null;
        }
    }

    public int getFuse() {
        return this.field_70180_af.func_75679_c(DATA_FUSE_TIMER);
    }

    public void setFuse(int f) {
        this.field_70180_af.func_75692_b(DATA_FUSE_TIMER, (Object)f);
    }
}

