/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.ext;

import com.builtbroken.mc.core.commands.ext.SubCommandWithName;
import com.builtbroken.mc.core.commands.permissions.GroupProfileHandler;
import com.builtbroken.mc.framework.access.AccessUser;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public abstract class UserSubCommand
extends SubCommandWithName {
    public UserSubCommand() {
        this("user");
    }

    public UserSubCommand(String name) {
        super(name);
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String user, String[] args) {
        return this.handleConsoleCommand((ICommandSender)player, user, args);
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String user, String[] args) {
        if (args.length > 0) {
            AccessUser accessUser = GroupProfileHandler.GLOBAL.getAccessProfile().getUserAccess(user);
            if (accessUser != null && accessUser.getGroup() != null) {
                return this.handle(sender, accessUser, this.removeFront(args));
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("User not found in permissions profile"));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Missing user name"));
        }
        return true;
    }

    public abstract boolean handle(ICommandSender var1, AccessUser var2, String[] var3);

    @Override
    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("[name]");
    }
}

