/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.energy;

import com.builtbroken.mc.core.commands.prefab.SubCommand;
import com.builtbroken.mc.framework.energy.UniversalEnergySystem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandChargeItem
extends SubCommand {
    public CommandChargeItem() {
        super("charge");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        block14: {
            int energy;
            boolean full;
            block13: {
                block15: {
                    if (args == null) return false;
                    if (args.length <= 0) return false;
                    if ("help".equalsIgnoreCase(args[0])) return false;
                    if (!args[0].equalsIgnoreCase("item")) break block14;
                    full = false;
                    energy = 0;
                    if (args.length <= 1) break block15;
                    if (args[1].equalsIgnoreCase("full")) {
                        full = true;
                        break block13;
                    } else {
                        try {
                            energy = Integer.parseInt(args[1]);
                            if (energy <= 0) {
                                player.func_146105_b((IChatComponent)new ChatComponentText("Energy value must be greater than zero!"));
                                return true;
                            }
                            break block13;
                        }
                        catch (NumberFormatException e) {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Need charge value of integer (ex 1, 10, 100) or use the word 'full' complete charge!"));
                            return true;
                        }
                    }
                }
                full = true;
            }
            ItemStack stack = player.func_70694_bm();
            if (stack == null) {
                player.func_146105_b((IChatComponent)new ChatComponentText("No held item to charge!"));
                return true;
            }
            if (!UniversalEnergySystem.isHandler(stack, null)) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Held item is not supported for energy based charging. If this is a mistake, make an issue at https://github.com/VoltzEngine-Project/Engine/issues asking for support to be added."));
                return true;
            }
            int received = 0;
            if (full) {
                received = (int)UniversalEnergySystem.setFullCharge(stack);
                player.field_71069_bz.func_75142_b();
            } else if (energy > 0) {
                received = (int)UniversalEnergySystem.fill(stack, null, energy, true);
                player.field_71069_bz.func_75142_b();
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("Error: Failed to select charge type of 'energy' or 'full' value, this is a logical error (bug) and not a user error"));
            }
            if (received == 1) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Item charged with " + received + " watt of energy"));
                return true;
            }
            if (received <= 0) return true;
            player.func_146105_b((IChatComponent)new ChatComponentText("Item charged with " + received + " watts of energy"));
            return true;
        }
        if (!args[0].equalsIgnoreCase("machine")) {
            if (!args[0].equalsIgnoreCase("tile")) return true;
        }
        player.func_146105_b((IChatComponent)new ChatComponentText("Not implemented yet!"));
        return true;
    }
}

