/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.asm;

import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.util.BlockSnapshot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckFakeWorld
extends World {
    public boolean debugInfo = false;
    public Logger logger = LogManager.getLogger((String)"FW-FakeWorld");

    public CheckFakeWorld(ISaveHandler p_i45369_1_, WorldSettings p_i45369_3_, WorldProvider p_i45369_4_) {
        super(p_i45369_1_, "FakeWorld", p_i45369_3_, p_i45369_4_, new Profiler());
    }

    public static CheckFakeWorld newWorld(String name) {
        WorldSettings settings = new WorldSettings(0L, WorldSettings.GameType.SURVIVAL, false, false, WorldType.field_77138_c);
        WorldInfo worldInfo = new WorldInfo(settings, name);
        CheckWorldSaveHandler handler = new CheckWorldSaveHandler(worldInfo);
        return new CheckFakeWorld(handler, settings, new CheckWorldProvider());
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProviderCheckServer(this, new ChunkProviderCheck(this));
    }

    protected int func_152379_p() {
        return 0;
    }

    public Entity func_73045_a(int p_73045_1_) {
        return null;
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int notify) {
        this.debug("");
        this.debug("setBlock(" + x + ", " + y + ", " + z + ", " + block + ", " + meta + ", " + notify);
        if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000) {
            if (y < 0) {
                this.debug("setBlock() y level is too low");
                return false;
            }
            if (y >= 256) {
                this.debug("setBlock() y level is too high");
                return false;
            }
            Chunk chunk = this.func_72964_e(x >> 4, z >> 4);
            this.debug("setBlock() chunk = " + chunk);
            Block block1 = null;
            BlockSnapshot blockSnapshot = null;
            if ((notify & 1) != 0) {
                block1 = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            }
            if (this.captureBlockSnapshots && !this.field_72995_K) {
                blockSnapshot = BlockSnapshot.getBlockSnapshot((World)this, (int)x, (int)y, (int)z, (int)notify);
                this.capturedBlockSnapshots.add(blockSnapshot);
            }
            boolean flag = chunk.func_150807_a(x & 0xF, y, z & 0xF, block, meta);
            this.debug("setBlock() flag = " + flag + " BlockSnapshot = " + blockSnapshot);
            if (!flag && blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
                blockSnapshot = null;
            }
            this.field_72984_F.func_76320_a("checkLight");
            this.func_147451_t(x, y, z);
            this.field_72984_F.func_76319_b();
            if (flag && blockSnapshot == null) {
                this.markAndNotifyBlock(x, y, z, chunk, block1, block, notify);
            }
            return flag;
        }
        this.debug("setBlock() too far from zero zero");
        return false;
    }

    protected void debug(String msg) {
        if (this.debugInfo) {
            this.logger.info(msg);
        }
    }

    public static class ChunkProviderCheck
    implements IChunkProvider {
        private World worldObj;

        public ChunkProviderCheck(World p_i2004_1_) {
            this.worldObj = p_i2004_1_;
        }

        public Chunk func_73158_c(int x, int z) {
            return this.func_73154_d(x, z);
        }

        public Chunk func_73154_d(int chunkX, int chunkZ) {
            Chunk chunk = new Chunk(this.worldObj, chunkX, chunkZ);
            chunk.func_76603_b();
            for (int l = 0; l < chunk.func_76605_m().length; ++l) {
                chunk.func_76605_m()[l] = 1;
            }
            chunk.func_76603_b();
            return chunk;
        }

        public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
            return true;
        }

        public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        }

        public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
            return true;
        }

        public void func_104112_b() {
        }

        public boolean func_73156_b() {
            return false;
        }

        public boolean func_73157_c() {
            return true;
        }

        public String func_73148_d() {
            return "sigVoidSource";
        }

        public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
            BiomeGenBase biomegenbase = this.worldObj.func_72807_a(p_73155_2_, p_73155_4_);
            return biomegenbase.func_76747_a(p_73155_1_);
        }

        public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
            return null;
        }

        public int func_73152_e() {
            return 0;
        }

        public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        }
    }

    public static class ChunkProviderCheckServer
    implements IChunkProvider {
        public IChunkProvider currentChunkProvider;
        public LongHashMap loadedChunkHashMap = new LongHashMap();
        public World worldObj;

        public ChunkProviderCheckServer(World p_i1520_1_, IChunkProvider p_i1520_3_) {
            this.worldObj = p_i1520_1_;
            this.currentChunkProvider = p_i1520_3_;
        }

        public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
            return this.loadedChunkHashMap.func_76161_b(ChunkCoordIntPair.func_77272_a((int)p_73149_1_, (int)p_73149_2_));
        }

        public Chunk func_73158_c(int par1, int par2) {
            Chunk chunk = new Chunk(this.worldObj, par1, par2);
            chunk.field_76636_d = true;
            this.loadedChunkHashMap.func_76163_a(ChunkCoordIntPair.func_77272_a((int)par1, (int)par2), (Object)chunk);
            return (Chunk)this.loadedChunkHashMap.func_76164_a(ChunkCoordIntPair.func_77272_a((int)par1, (int)par2));
        }

        public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
            Chunk chunk = (Chunk)this.loadedChunkHashMap.func_76164_a(ChunkCoordIntPair.func_77272_a((int)p_73154_1_, (int)p_73154_2_));
            return chunk == null ? this.func_73158_c(p_73154_1_, p_73154_2_) : chunk;
        }

        public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
            Chunk chunk = this.func_73154_d(p_73153_2_, p_73153_3_);
            if (!chunk.field_76646_k) {
                chunk.func_150809_p();
                if (this.currentChunkProvider != null) {
                    this.currentChunkProvider.func_73153_a(p_73153_1_, p_73153_2_, p_73153_3_);
                    chunk.func_76630_e();
                }
            }
        }

        public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
            return true;
        }

        public boolean func_73156_b() {
            return false;
        }

        public boolean func_73157_c() {
            return false;
        }

        public String func_73148_d() {
            return "ServerChunkCache: " + this.loadedChunkHashMap.func_76162_a();
        }

        public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
            return this.currentChunkProvider.func_73155_a(p_73155_1_, p_73155_2_, p_73155_3_, p_73155_4_);
        }

        public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
            return this.currentChunkProvider.func_147416_a(p_147416_1_, p_147416_2_, p_147416_3_, p_147416_4_, p_147416_5_);
        }

        public int func_73152_e() {
            return this.loadedChunkHashMap.func_76162_a();
        }

        public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        }

        public void func_104112_b() {
        }
    }

    public static class CheckWorldSaveHandler
    implements ISaveHandler {
        WorldInfo info;
        File dataDir;

        public CheckWorldSaveHandler(WorldInfo info) {
            this.info = info;
            this.dataDir = new File(new File("."), "data");
            this.dataDir.mkdirs();
        }

        public WorldInfo func_75757_d() {
            return this.info;
        }

        public void func_75762_c() throws MinecraftException {
        }

        public IChunkLoader func_75763_a(WorldProvider provider) {
            return null;
        }

        public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
        }

        public void func_75761_a(WorldInfo p_75761_1_) {
        }

        public IPlayerFileData func_75756_e() {
            return null;
        }

        public void func_75759_a() {
        }

        public File func_75765_b() {
            return this.dataDir;
        }

        public File func_75758_b(String s) {
            return new File(this.dataDir, s);
        }

        public String func_75760_g() {
            return "MinecraftUnitTesting";
        }
    }

    public static class CheckWorldProvider
    extends WorldProvider {
        public CheckWorldProvider() {
            this.field_76577_b = WorldType.field_77138_c;
        }

        public String func_80007_l() {
            return "FakeWorld";
        }
    }
}

