/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.state;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.state.RenderState;
import com.builtbroken.mc.client.json.texture.TextureData;
import java.util.List;
import net.minecraft.util.IIcon;

public class RenderStateTexture
extends RenderState
implements IRenderState {
    private String textureID;

    public RenderStateTexture(String id) {
        super(id);
    }

    @Override
    public IIcon getIcon(int side) {
        TextureData textureData = this.getTextureData(side);
        if (textureData != null && textureData.getIcon() != null) {
            return textureData.getIcon();
        }
        return null;
    }

    @Override
    public TextureData getTextureData(int side) {
        if (this.getTextureID() != null) {
            return ClientDataHandler.INSTANCE.getTexture(this.getTextureID());
        }
        return this.parentState != null ? this.parentState.getTextureData(side) : null;
    }

    public String getTextureID() {
        return this.textureID;
    }

    public void setTextureID(String textureID) {
        this.textureID = textureID;
    }

    @Override
    public void addDebugLines(List<String> lines) {
        super.addDebugLines(lines);
        lines.add("Texture ID = " + this.getTextureID());
        lines.add("Texture = " + this.getTextureData(0));
    }

    public String toString() {
        return "RenderTextureState[" + this.id + ", " + this.getTextureID() + "]@" + this.hashCode();
    }
}

