/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.processor;

import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.client.json.render.state.RenderState;
import com.builtbroken.mc.client.json.render.state.RenderStateTexture;
import com.builtbroken.mc.client.json.texture.TextureData;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class RenderJsonSubProcessor<S extends IRenderState> {
    public final TextureData.Type textureType;

    public RenderJsonSubProcessor(TextureData.Type textureType) {
        this.textureType = textureType;
    }

    public abstract S process(JsonObject var1, String var2, String var3, String var4);

    protected void process(S state, JsonObject renderStateObject) {
        if (state instanceof RenderState) {
            if (renderStateObject.has("parent")) {
                ((RenderState)state).parent = renderStateObject.get("parent").getAsString();
            }
            if (renderStateObject.has("color")) {
                ((RenderState)state).color = renderStateObject.get("color").getAsString();
            }
            if (renderStateObject.has("textureID")) {
                this.setMainTexture(state, renderStateObject.get("textureID").getAsString());
            }
            if (renderStateObject.has("texture") && renderStateObject.get("texture").isJsonPrimitive()) {
                String textureID = renderStateObject.get("texture").getAsString();
                this.setMainTexture(state, textureID);
            } else {
                for (Map.Entry elementEntry : renderStateObject.entrySet()) {
                    if (!((String)elementEntry.getKey()).equalsIgnoreCase("texture") && (!((String)elementEntry.getKey()).contains(":") || !((String)elementEntry.getKey()).split(":")[0].equalsIgnoreCase("texture"))) continue;
                    JsonObject textureData = ((JsonElement)elementEntry.getValue()).getAsJsonObject();
                    JsonProcessor.ensureValuesExist(textureData, "domain", "name");
                    String domain = textureData.getAsJsonPrimitive("domain").getAsString();
                    String name = textureData.getAsJsonPrimitive("name").getAsString();
                    String key = textureData.has("key") ? textureData.getAsJsonPrimitive("key").getAsString() : domain + ":" + name;
                    if (!this.hasTexture(state)) {
                        this.setMainTexture(state, key);
                    }
                    TextureData data = new TextureData(null, key, domain, name, this.textureType);
                    List<IJsonGenObject> list = JsonContentLoader.INSTANCE.generatedObjects.get("texture");
                    if (list == null) {
                        list = new ArrayList<IJsonGenObject>();
                    }
                    list.add(data);
                    JsonContentLoader.INSTANCE.generatedObjects.put("texture", list);
                    data.onCreated();
                }
            }
        }
    }

    protected void setMainTexture(S state, String key) {
        if (state instanceof RenderStateTexture) {
            ((RenderStateTexture)state).setTextureID(key);
        }
    }

    protected boolean hasTexture(S state) {
        if (state instanceof RenderStateTexture) {
            return ((RenderStateTexture)state).getTextureID() != null;
        }
        return false;
    }

    public void postHandle(IRenderState state, RenderData data) {
        if (state instanceof RenderState && ((RenderState)state).parent != null) {
            IRenderState parentState = data.getState(((RenderState)state).parent);
            if (parentState != null) {
                ((RenderState)state).parentState = parentState;
            } else {
                throw new RuntimeException("Failed to locate a render state parent with name '" + ((RenderState)state).parent + "' for render state '" + ((RenderState)state).id);
            }
        }
    }

    public static void ensureValuesExist(JsonObject object, String ... values) {
        for (String value : values) {
            if (object.has(value)) continue;
            throw new IllegalArgumentException("File is missing " + value + " value " + object);
        }
    }

    public abstract boolean canProcess(String var1);
}

