/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.block;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.render.state.RenderState;
import com.builtbroken.mc.client.json.texture.TextureData;
import java.util.List;
import net.minecraft.util.IIcon;

public class RenderStateBlock
extends RenderState {
    public final String[] textureID = new String[6];

    public RenderStateBlock(String id) {
        super(id);
    }

    @Override
    public IIcon getIcon(int side) {
        TextureData textureData = this.getTextureData(side);
        if (textureData != null && textureData.getIcon() != null) {
            return textureData.getIcon();
        }
        return null;
    }

    @Override
    public TextureData getTextureData(int side) {
        if (side >= 0 && side < 6) {
            return this.textureID[side] != null ? ClientDataHandler.INSTANCE.getTexture(this.textureID[side]) : null;
        }
        if (this.parentState != null) {
            return this.parentState.getTextureData(side);
        }
        return this.getTextureData(0);
    }

    @Override
    public void addDebugLines(List<String> lines) {
        super.addDebugLines(lines);
        int i = 0;
        lines.add("Textures");
        for (String s : this.textureID) {
            lines.add("  [" + i++ + "] = " + s);
        }
    }

    public String toString() {
        return "RenderStateBlock[" + this.id + "]@" + this.hashCode();
    }
}

