/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.IJsonRenderStateProvider;
import com.builtbroken.mc.client.json.imp.IModelState;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.debug.gui.windows.FrameRenderData;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class RenderData
extends JsonGenData
implements IJsonDebugDisplay {
    public static final String INVENTORY_RENDER_KEY = "item.inventory";
    public static final String EQUIPPED_RENDER_KEY = "item.equipped";
    public static final String FIRST_PERSON_RENDER_KEY = "item.first";
    public static final String ENTITY_RENDER_KEY = "item.entity";
    public final String contentID;
    public final String renderType;
    protected int itemRenderLayers = 1;
    protected HashMap<Integer, Integer> itemRenderLayerPerMeta = new HashMap();
    public HashMap<String, IRenderState> renderStatesByName = new HashMap();
    FrameRenderData debugWindow;

    public RenderData(IJsonProcessor processor, String contentID, String type) {
        super(processor);
        this.contentID = contentID;
        this.renderType = type;
    }

    public IRenderState getState(String state) {
        return this.renderStatesByName.get(state);
    }

    public boolean hasState(String state) {
        return this.renderStatesByName.get(state) != null;
    }

    public boolean canRenderState(String state) {
        return this.hasState(state) && this.getState(state) instanceof IModelState;
    }

    public boolean render(String state) {
        if (this.canRenderState(state)) {
            try {
                return ((IModelState)this.getState(state)).render(false);
            }
            catch (Exception e) {
                Engine.logger().error("RenderData: Error rendering model state " + state, (Throwable)e);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onCreated() {
        ClientDataHandler.INSTANCE.addRenderData(this.contentID, this);
    }

    @Override
    public String getContentID() {
        return this.contentID;
    }

    @Override
    public String getUniqueID() {
        return this.contentID;
    }

    public boolean render(IItemRenderer.ItemRenderType type, String stateKey, Object item) {
        return this.render(this.getRenderKeyForState(type, stateKey, item));
    }

    public String getRenderKeyForState(IItemRenderer.ItemRenderType type, String stateKey, Object item) {
        String key = null;
        if (item instanceof IJsonRenderStateProvider) {
            key = ((IJsonRenderStateProvider)item).getRenderStateKey(type, stateKey, item);
        } else if (item instanceof ItemStack && ((ItemStack)item).func_77973_b() instanceof IJsonRenderStateProvider) {
            key = ((IJsonRenderStateProvider)((ItemStack)item).func_77973_b()).getRenderStateKey(type, stateKey, item);
        }
        switch (type) {
            case ENTITY: {
                key = ENTITY_RENDER_KEY + (stateKey != null ? "." + stateKey : "");
                break;
            }
            case INVENTORY: {
                key = INVENTORY_RENDER_KEY + (stateKey != null ? "." + stateKey : "");
                break;
            }
            case EQUIPPED: {
                key = EQUIPPED_RENDER_KEY + (stateKey != null ? "." + stateKey : "");
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                key = FIRST_PERSON_RENDER_KEY + (stateKey != null ? "." + stateKey : "");
            }
        }
        return key;
    }

    public boolean shouldRenderType(IItemRenderer.ItemRenderType type, String key, Object item) {
        return this.canRenderState(this.getRenderKeyForState(type, key, item));
    }

    public void add(String name, IRenderState state) {
        this.renderStatesByName.put(name, state);
    }

    public int getItemRenderLayers(int meta) {
        if (this.itemRenderLayerPerMeta.containsKey(meta)) {
            return this.itemRenderLayerPerMeta.get(meta);
        }
        return this.itemRenderLayers;
    }

    public void setItemLayers(int itemLayers) {
        this.itemRenderLayers = itemLayers;
    }

    public void setItemLayers(int meta, int itemLayers) {
        this.itemRenderLayerPerMeta.put(meta, itemLayers);
    }

    public String toString() {
        return "RenderData[" + this.contentID + "]";
    }

    @Override
    public String getDisplayName() {
        return "RenderData[" + this.contentID + "]";
    }

    @Override
    public void addDebugLines(List<String> lines) {
        lines.add("Type: " + this.renderType);
        lines.add("States: " + this.renderStatesByName.size());
    }

    @Override
    public void onDoubleClickLine() {
        if (Engine.runningAsDev) {
            if (this.debugWindow == null) {
                this.debugWindow = new FrameRenderData(this);
            }
            this.debugWindow.show();
        }
    }
}

