/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json;

import com.builtbroken.mc.client.json.audio.AudioData;
import com.builtbroken.mc.client.json.imp.IEffectData;
import com.builtbroken.mc.client.json.models.ModelData;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.client.json.texture.TextureData;
import com.builtbroken.mc.core.Engine;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ClientDataHandler {
    public HashMap<String, ModelData> models = new HashMap();
    public HashMap<String, TextureData> textures = new HashMap();
    public HashMap<String, RenderData> renderData = new HashMap();
    public HashMap<String, AudioData> audioData = new HashMap();
    public HashMap<String, IEffectData> effectData = new HashMap();
    public HashMap<String, ISimpleBlockRenderingHandler> blockRenders = new HashMap();
    public static final ClientDataHandler INSTANCE = new ClientDataHandler();

    public void addTexture(String key, TextureData texture) {
        if (this.textures.containsKey(key.toLowerCase())) {
            Engine.logger().error("Overriding " + this.textures.get(key) + " with " + texture);
        }
        this.textures.put(key.toLowerCase(), texture);
    }

    public void addModel(String key, ModelData model) {
        if (this.models.containsKey(key.toLowerCase())) {
            Engine.logger().error("Overriding " + this.models.get(key) + " with " + model);
        }
        this.models.put(key.toLowerCase(), model);
    }

    public void addRenderData(String key, RenderData data) {
        if (this.renderData.containsKey(key.toLowerCase())) {
            Engine.logger().error("Overriding " + this.renderData.get(key) + " with " + data);
        }
        this.renderData.put(key.toLowerCase(), data);
    }

    public void addAudio(String key, AudioData data) {
        if (this.audioData.containsKey(key.toLowerCase())) {
            Engine.logger().error("Overriding " + this.audioData.get(key) + " with " + data);
        }
        this.audioData.put(key.toLowerCase(), data);
    }

    public void addEffect(String key, IEffectData data) {
        if (this.effectData.containsKey(key.toLowerCase())) {
            Engine.logger().error("Overriding " + this.effectData.get(key) + " with " + data);
        }
        this.effectData.put(key.toLowerCase(), data);
    }

    public void addBlockRenderer(String key, ISimpleBlockRenderingHandler renderer) {
        if (this.blockRenders.containsKey(key.toLowerCase())) {
            Engine.logger().error("Overriding " + this.blockRenders.get(key) + " with " + renderer);
        }
        this.blockRenders.put(key.toLowerCase(), renderer);
    }

    public RenderData getRenderData(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.renderData.get(key.toLowerCase());
    }

    public ModelData getModel(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.models.get(key.toLowerCase());
    }

    public TextureData getTexture(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.textures.get(key.toLowerCase());
    }

    public AudioData getAudio(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.audioData.get(key.toLowerCase());
    }

    public IEffectData getEffect(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.effectData.get(key.toLowerCase());
    }

    public ISimpleBlockRenderingHandler getBlockRender(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.blockRenders.get(key.toLowerCase());
    }

    @SubscribeEvent
    public void textureEvent(TextureStitchEvent.Pre event) {
        int textureType = event.map.func_130086_a();
        for (TextureData data : this.textures.values()) {
            if (textureType == 0 && data.type == TextureData.Type.BLOCK) {
                data.register((IIconRegister)event.map);
                continue;
            }
            if (textureType != 1 || data.type != TextureData.Type.ITEM) continue;
            data.register((IIconRegister)event.map);
        }
    }

    public boolean canSupportColor(String colorKey) {
        return false;
    }

    public int getColorAsInt(String colorKey) {
        return 0xFFFFFF;
    }

    public Color getColor(String colorKey) {
        return null;
    }
}

